/* --------------------------------------------------------------
   PayPalLoader.js 2020-10-06
   Gambio GmbH
   http://www.gambio.de
   Copyright (c) 2019 Gambio GmbH
   Released under the GNU General Public License (Version 2)
   [http://www.gnu.org/licenses/gpl-2.0.html]
   --------------------------------------------------------------
*/


(function() {
	if (window.NodeList && !NodeList.prototype.forEach) {
		NodeList.prototype.forEach = Array.prototype.forEach;
	}

	let currentScript = document.currentScript;

	let initDisplayModeECS_ButtonReplace = function() {
		let paypalButtonContainer = document.querySelector('#paypal-button-container'),
			footerTotalRow = document.querySelector('table.order-total tr.footer.total'),
			newTotalRow = document.createElement('tr'),
			newTotalRowCell = document.createElement('td');
		newTotalRowCell.colSpan = '2';
		newTotalRowCell.style.width = '100%';
		newTotalRowCell.style.borderTop = 'none';
		newTotalRowCell.appendChild(paypalButtonContainer);
		newTotalRow.appendChild(newTotalRowCell);
		footerTotalRow.parentNode.appendChild(newTotalRow);
		footerTotalRow.querySelectorAll('td').forEach(function(td) {
			td.style.paddingBottom = '15px';
		});
	};

	let initDisplayModeECS = function() {
		if(window.location.search.match(/(\?|&)display_mode=ecs($|&)/)) {
			let checkoutButtons = document.querySelector('div.checkout-buttons');
			if(checkoutButtons) {
				checkoutButtons.style.display = 'none';
			}
			let checkoutSubmitButton = document.querySelector('div.shopping-cart-button a.button-submit');
			if(checkoutSubmitButton === null) {
				checkoutSubmitButton = document.querySelector('tr.checkout-button');
			}
			if(checkoutSubmitButton) {
				checkoutSubmitButton.style.display = 'none';
			}
			let shoppingCartButton = document.querySelector('div.shopping-cart-button');
			if(shoppingCartButton) {
				shoppingCartButton.classList.add('paypal-ecs-mode');
			}
			let ppiContainer = document.querySelector('div.paypalinstallmentcontainer');
			if(ppiContainer) {
				ppiContainer.style.display = 'none';
			}
			initDisplayModeECS_ButtonReplace();
		}
	}

	let initJSSDKPayPalButtonECS = function() {
		let buttonContainer = document.querySelector('#paypal-button-container');
		if (!buttonContainer) {
			return;
		}
        let ecsIntro = document.querySelector('div.ecs_intro');
        if (document.querySelector('tr.checkout-button .button-disabled') !== null) {
            if (ecsIntro) {
                ecsIntro.style.display = 'none';
            }
            buttonContainer.style.display = 'none';
        } else {
            if (ecsIntro) {
                ecsIntro.style.display = 'block';
            }
            buttonContainer.style.display = 'block';
            initDisplayModeECS();
        }

		paypal.Buttons({
			style: payPalButtonSettings.style,
			createOrder: function(data, actions) {
				return $.ajax({
					url: payPalButtonSettings.createPaymentUrl,
					dataType: 'json'
				}).then(function(data) {
					let token;
					if (data.payment) {
						for (let link in data.payment.links) {
							if (data.payment.links[link].rel === 'approval_url') {
								token = data.payment.links[link].href.match(/EC-\w+/)[0];
							}
						}
					} else {
						//throw new Error(payPalText.paypalUnavailable);
						return false;
					}
					return token;
				});
			},
			onApprove: function(data, actions) {
				$.ajax({
					url: payPalButtonSettings.authorizedPaymentUrl,
					method: 'post',
					headers: {
						'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'
					},
					data: 'paymentID=' + data.paymentID + '&payerID=' + data.payerID
				}).then(function (res) {
					console.debug(res);
					document.location = payPalButtonSettings.checkoutUrl;
				});
			},
			onError: function(err) {
				let ppButtonContainer = document.querySelector('#paypal-button-container');
				let ecsIntro = document.querySelector('div.ecs_intro');
				if(ppButtonContainer) {
					let errorMessage = document.querySelector('div.paypal-error');
					if(!errorMessage) {
						errorMessage = document.createElement('div');
						errorMessage.classList.add('paypal-error');
						errorMessage.classList.add('alert');
						errorMessage.classList.add('alert-warning');
						errorMessage.style.textAlign = 'left';
						errorMessage.style.color = '#555';
					}
					errorMessage.innerText = payPalText.paypalUnavailable + ' ';
					let shoppingCartButton = document.querySelector('div.shopping-cart-button');
					if(shoppingCartButton && shoppingCartButton.classList.contains('paypal-ecs-mode')) {
						let linkUrl = window.location.toString().replace('display_mode=ecs', 'display_mode=normal');
						let continueLink = document.createElement('a');
						continueLink.setAttribute('href', linkUrl);
						continueLink.innerText = payPalText.errorContinue;
						errorMessage.append(continueLink);
					}
					ppButtonContainer.parentNode.append(errorMessage);
					ppButtonContainer.style.display = 'none';
				}
				if(ecsIntro) {
					ecsIntro.style.display = 'none';
				}
			}
		}).render('#paypal-button-container');

		let observerTarget = document.querySelector('#paypal-button-container');
		let observer = new MutationObserver(function(mutations, observer) {
			mutations.forEach(function(mutation) {
				// console.debug(mutation);
				if(mutation.removedNodes.length > 0) {
					console.info('re-init PayPal buttons');
					initJSSDKPayPalButtonECS();
				}
			});
		});
		observer.observe(observerTarget, {childList: true});
	};


	let initJSSDKPayPalButtonECM = function()
	{
		paypal.Buttons({
			style: payPalButtonSettings.style,
			createOrder: function(data, actions) {
				return $.ajax({
					url: payPalButtonSettings.createPaymentUrl,
					dataType: 'json'
				}).then(function(data) {
					let token;
					for (let link in data.payment.links) {
						if (data.payment.links[link].rel === 'approval_url') {
							token = data.payment.links[link].href.match(/EC-\w+/)[0];
						}
					}
					return token;
				});
			},
			onApprove: function(data, actions) {
				document.querySelector('#checkout_payment input[name="PayPal2HubPaymentId"]').value = data.paymentID;
				document.querySelector('#checkout_payment input[name="PayPal2HubPayerId"]').value = data.payerID;
				document.querySelector('#checkout_payment').submit();
			}
		}).render('#paypal-button-container');
	}


	let initCheckoutPayment = function() {
		let continueButtonBlock = document.querySelector('#checkout_payment div.continue_button'),
			continueButton = continueButtonBlock.querySelector('input[type="submit"]'),
			continueButtonDisplay = continueButton.style.display,
			paypalButtonContainer = document.createElement('div'),
			plusContainer = document.querySelector('#gambiohub-ppplus');

		if (plusContainer === null && !payPalButtonSettings.paymentApproved) {
			paypalButtonContainer.id = 'paypal-button-container';
			paypalButtonContainer.style.display = 'none';
			continueButtonBlock.appendChild(paypalButtonContainer);

			initJSSDKPayPalButtonECM();

			let paymentItemClickListener = function() {
				let selected_payment = this.querySelector('input[name="payment"]');
				if (null !== selected_payment) {
					if (selected_payment.value === 'gambio_hub' && selected_payment.dataset.module_code
						=== 'PayPal2Hub') {
						continueButton.style.display = 'none';
						paypalButtonContainer.style.display = 'block';
					} else {
						continueButton.style.display = continueButtonDisplay;
						paypalButtonContainer.style.display = 'none';
					}
				}
			};

			let paymentItems = document.querySelectorAll('#checkout_payment input[name="payment"], #checkout_payment li.list-group-item');
			paymentItems.forEach(function(paymentItem) {
				paymentItem.addEventListener('click', paymentItemClickListener)
			});

			let paymentListEntries = document.querySelectorAll('#checkout_payment li');
			paymentListEntries.forEach(function(paymentOption) {
				if (paymentOption.querySelector('input[name="payment"]:checked') || paymentListEntries.length === 1) {
					paymentOption.dispatchEvent(new Event('click'));
				}
			});
		}
	}

	/****
	 ****  Installment Banners
 	 */

	let initInstallmentBanners = function() {
		console.info('Initialising PayPal Installments banners');
		console.info('CartAmount = ' + payPalBannerSettings.cartAmount);
		let banners = document.querySelectorAll('.paypal-installments');
		banners.forEach(function(bannerElement) {
			let position = bannerElement.dataset.ppinstPos;
			console.info('found banner on position ' + position);
			if (payPalBannerSettings.positions && payPalBannerSettings.positions[position]) {
				console.info('settings found for position ' + position);
				console.debug(payPalBannerSettings.positions[position]);
				if (payPalBannerSettings.positions[position].style.layout === 'none') {
					console.info('position disabled');
					return;
				}

				let amount = 0.00;
				if (payPalBannerSettings.cartAmount) {
					amount += payPalBannerSettings.cartAmount;
				}
				let p = document.querySelector('div.current-price-container');
				if(p) {
                    amount += 0.01 * parseFloat(p.innerText.replace(/.*?(((\d{1,3}[.,])+)(\d{2})).*/, '$1').replace(/[.,]/g, ''));
				}
				if (amount === 0.00) {
					console.debug('Not showing PayPal Installments banner for amount ' + amount);
				}

				if(bannerElement.classList.contains('paypal-installments-cartbottom')) {
					let observerTarget = document.querySelector('div.shopping-cart-button');
					if (observerTarget) {
						let cartSumElement = document.querySelector('tr.total.sum td:nth-child(2)');
						let amountString = '0';
						if(cartSumElement) {
							amountString = cartSumElement.textContent.trim();
						} else {
							cartSumElement = document.querySelector('tr.footer.total td:nth-child(2)');
							if(cartSumElement) {
								amountString = cartSumElement.textContent.trim()
									.replace(/(\n|\t|\.|\,)/g, '')
									.replace(/.*?([0-9.,]+)\s+EUR.*/, '$1');
							}
						}
                        amount = 0.01 * parseInt(amountString.replace(/[^0-9]/g, ''));
						console.info('cart amount ' + amount);

						let observer = new MutationObserver(function(mutations, observer) {
							mutations.forEach(function(mutation) {
								if(mutation.removedNodes.length > 0) {
									console.info('re-init PayPal installments banner');
									initInstallmentBanners();
								}
							});
						});
						observer.observe(observerTarget, {childList: true});
					}
				}

				paypal.Messages({
					amount: amount,
					currency: payPalBannerSettings.currency,
					style: payPalBannerSettings.positions[position].style,
					placement: payPalBannerSettings.positions[position].placement
				}).render(bannerElement)
                    .then(function() {
                        let legacyInstallmentContainer = document.querySelector('.paypalinstallmentcontainer');
                        if(legacyInstallmentContainer) {
                            legacyInstallmentContainer.remove();
                        }
                    });
			}
		});
	};

	let paypalSdkLoaded = function() {
		console.info('PayPalSDK loaded');
		if(window.location.pathname.match(/shopping_cart.php/)) {
			console.info('Initializing ECS button');
			initJSSDKPayPalButtonECS();
		}
		if(window.location.pathname.match(/checkout_payment.php/)) {
			console.info('Initializing PayPal on payment page');
			initCheckoutPayment();
		}
		initInstallmentBanners();
	};

	let readyCallback = function() {
		let jssrc = '';
        if (typeof (payPalButtonSettings) !== 'undefined' && payPalButtonSettings.jssrc) {
            jssrc = payPalButtonSettings.jssrc;
        } else if (typeof (payPalBannerSettings) !== 'undefined' && payPalBannerSettings.jssrc) {
            jssrc = payPalBannerSettings.jssrc;
        }

		if (jssrc && typeof(window.paypal) === 'undefined') {
			let jssdk = document.createElement('script');
			jssdk.src = payPalButtonSettings.jssrc ? payPalButtonSettings.jssrc : payPalBannerSettings.jssrc;
			jssdk.onload = paypalSdkLoaded;

			if(currentScript) {
				currentScript.parentNode.insertBefore(jssdk, currentScript);
			} else {
				document.querySelector('script:last-of-type').parentNode.appendChild(jssdk);
			}
		} else {
			console.info('PayPal JSSDK unavailable');
		}
	};

	if(document.readyState === 'complete' || (document.readyState !== 'loading' && !document.documentElement.doScroll)) {
		readyCallback();
	} else {
		document.addEventListener('DOMContentLoaded', readyCallback);
	}
}());
